/*
 * Decompiled with CFR 0.152.
 */
package goowee.scheduler;

import goowee.commons.utils.FileUtils;
import goowee.core.ApplicationService;
import goowee.notification.NotificationTemplateService;
import goowee.properties.SystemPropertyService;
import goowee.scheduler.SchedulerJobService;
import goowee.scheduler.SchedulerScheduleService;
import goowee.scheduler.TSchedulerSchedule;
import goowee.scheduler.TSchedulerTask;
import goowee.security.SecurityService;
import goowee.tenants.TenantService;
import grails.artefact.Artefact;
import grails.plugins.metadata.GrailsPlugin;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GrailsPlugin(name="gooweeScheduler", version="1.x-SNAPSHOT")
@Artefact(value="Service")
public class SchedulerInitService
implements GroovyObject {
    private ApplicationService applicationService;
    private SecurityService securityService;
    private TenantService tenantService;
    private SystemPropertyService systemPropertyService;
    private SchedulerScheduleService schedulerScheduleService;
    private SchedulerJobService schedulerJobService;
    private NotificationTemplateService notificationTemplateService;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public SchedulerInitService() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void install(String tenantId) {
        IndyInterface.bootstrap("invoke", "createAuthority", 0, this.securityService, "ROLE_SCHEDULER");
        CallSite logDir = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "privateDir", 4, this.tenantService), "scheduler/logs"));
        IndyInterface.bootstrap("invoke", "setDirectory", 0, this.systemPropertyService, "SCHEDULER_LOG_DIR", logDir);
        IndyInterface.bootstrap("invoke", "createDirectory", 0, FileUtils.class, logDir);
        IndyInterface.bootstrap("invoke", "create", 0, this.notificationTemplateService, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"failOnError", false, "name", IndyInterface.bootstrap("getProperty", "NOTIFICATION_TEMPLATE_SUCCESS", 4, this.schedulerScheduleService), "availableParams", ScriptBytecodeAdapter.createList((Object[])new Object[]{"schedule", "fullname"}), "translations", ScriptBytecodeAdapter.createList((Object[])new Object[]{ScriptBytecodeAdapter.createMap((Object[])new Object[]{"language", "en", "subject", "Schedule \"${schedule}\" completed successfully", "body", "\nDear ${fullname},\n\nthe schedule \"${schedule}\" has completed successfully.\n\nNo further action is required,\nit is safe to delete this notification.\n\nPlease do not reply, replies to this message are not monitored.\n                        "})})}));
        IndyInterface.bootstrap("invoke", "create", 0, this.notificationTemplateService, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"failOnError", false, "name", IndyInterface.bootstrap("getProperty", "NOTIFICATION_TEMPLATE_ERROR", 4, this.schedulerScheduleService), "availableParams", ScriptBytecodeAdapter.createList((Object[])new Object[]{"fullname", "schedule", "job", "task", "exitCode"}), "translations", ScriptBytecodeAdapter.createList((Object[])new Object[]{ScriptBytecodeAdapter.createMap((Object[])new Object[]{"language", "en", "subject", "ERROR executing schedule \"${schedule}\"", "body", "\nDear ${fullname},\n\nthe schedule \"${schedule}\" ended with ERROR and has been interrupted.\n\njob: ${job}\ntask: ${task} \nexitCode: ${exitCode}\n\nManual actions may be required before to successfully execute the schedule.\n\nPlease do not reply, replies to this message are not monitored.\n                        "})})}));
        IndyInterface.bootstrap("invoke", "create", 0, this.notificationTemplateService, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"failOnError", false, "name", IndyInterface.bootstrap("getProperty", "NOTIFICATION_TEMPLATE_SUCCESS", 4, this.schedulerJobService), "availableParams", ScriptBytecodeAdapter.createList((Object[])new Object[]{"fullname", "schedule", "job", "task"}), "translations", ScriptBytecodeAdapter.createList((Object[])new Object[]{ScriptBytecodeAdapter.createMap((Object[])new Object[]{"language", "en", "subject", "Task \"${task}\" of job \"${job}\" in schedule \"${schedule}\" completed successfully.", "body", "\nDear ${fullname},\n\nthe task \"${task}\" has completed successfully.\n\nNo further action is required,\nit is safe to delete this notification.\n\nPlease do not reply, replies to this message are not monitored.\n                        "})})}));
        IndyInterface.bootstrap("invoke", "create", 0, this.notificationTemplateService, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"failOnError", false, "name", IndyInterface.bootstrap("getProperty", "NOTIFICATION_TEMPLATE_ERROR", 4, this.schedulerJobService), "availableParams", ScriptBytecodeAdapter.createList((Object[])new Object[]{"fullname", "schedule", "job", "task", "exitCode"}), "translations", ScriptBytecodeAdapter.createList((Object[])new Object[]{ScriptBytecodeAdapter.createMap((Object[])new Object[]{"language", "en", "subject", "Task \"${task}\" of job \"${job}\" in schedule \"${schedule}\" terminated with exit code \"${exitCode}\".", "body", "\nDear ${fullname},\n\nthe task \"${task}\" terminated with exit code \"${exitCode}\".\n\nschedule: ${schedule}\njob: ${job}\ntask: ${task}\nexitCode: ${exitCode}\n\nManual actions may be required before to successfully execute the job.\n\nPlease do not reply, replies to this message are not monitored.\n                        "})})}));
        IndyInterface.bootstrap("invoke", "installGrailsJobsAsTasks", 0, this.schedulerScheduleService);
    }

    public void init() {
        IndyInterface.bootstrap("invoke", "registerPrettyPrinter", 0, this.applicationService, TSchedulerTask.class, "${it.name} (${it.type})");
        IndyInterface.bootstrap("invoke", "registerPrettyPrinter", 0, this.applicationService, TSchedulerSchedule.class, "${it.name}${it.deletable ? \"\" : \" (system)\"}");
        IndyInterface.bootstrap("invoke", "installGrailsJobsAsTasks", 0, this.schedulerScheduleService);
    }

    public void registerFeatures() {
        IndyInterface.bootstrap("invoke", "registerFeature", 0, this.applicationService, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"controller", "scheduler", "authorities", ScriptBytecodeAdapter.createList((Object[])new Object[]{"ROLE_SCHEDULER"})}));
        IndyInterface.bootstrap("invoke", "registerFeature", 0, this.applicationService, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"parent", "scheduler", "controller", "schedulerSchedule", "icon", "fa-clock", "authorities", ScriptBytecodeAdapter.createList((Object[])new Object[]{"ROLE_SCHEDULER"})}));
        IndyInterface.bootstrap("invoke", "registerFeature", 0, this.applicationService, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"parent", "scheduler", "controller", "schedulerJobExecution", "icon", "fa-rocket", "authorities", ScriptBytecodeAdapter.createList((Object[])new Object[]{"ROLE_SCHEDULER"})}));
        IndyInterface.bootstrap("invoke", "registerFeature", 0, this.applicationService, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"parent", "scheduler", "controller", "schedulerTask", "icon", "fa-server", "authorities", ScriptBytecodeAdapter.createList((Object[])new Object[]{"ROLE_SCHEDULER"})}));
        IndyInterface.bootstrap("invoke", "registerFeature", 0, this.applicationService, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"parent", "scheduler", "controller", "schedulerTrigger", "icon", "fa-bolt", "authorities", ScriptBytecodeAdapter.createList((Object[])new Object[]{"ROLE_SUPERADMIN"})}));
    }

    public void refreshTriggers() {
        IndyInterface.bootstrap("invoke", "unscheduleAllTriggers", 0, this.schedulerScheduleService);
        public final class _refreshTriggers_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _refreshTriggers_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String tenantId) {
                CallSite schedules = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "listAll", 0, IndyInterface.bootstrap("getProperty", "schedulerScheduleService", 8, this)));
                Object schedule = null;
                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, schedules));
                if (callSite != null) {
                    while (callSite.hasNext()) {
                        schedule = callSite.next();
                        IndyInterface.bootstrap("invoke", "updateTriggers", 0, IndyInterface.bootstrap("getProperty", "schedulerScheduleService", 8, this), schedule);
                    }
                }
                return null;
            }

            @Generated
            public Object call(String tenantId) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, tenantId);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _refreshTriggers_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "eachTenant", 0, this.tenantService, new _refreshTriggers_closure1(this, this));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SchedulerInitService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "goowee.scheduler.SchedulerInitService");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public ApplicationService getApplicationService() {
        return this.applicationService;
    }

    @Generated
    public void setApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    @Generated
    public SecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Generated
    public TenantService getTenantService() {
        return this.tenantService;
    }

    @Generated
    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @Generated
    public SystemPropertyService getSystemPropertyService() {
        return this.systemPropertyService;
    }

    @Generated
    public void setSystemPropertyService(SystemPropertyService systemPropertyService) {
        this.systemPropertyService = systemPropertyService;
    }

    @Generated
    public SchedulerScheduleService getSchedulerScheduleService() {
        return this.schedulerScheduleService;
    }

    @Generated
    public void setSchedulerScheduleService(SchedulerScheduleService schedulerScheduleService) {
        this.schedulerScheduleService = schedulerScheduleService;
    }

    @Generated
    public SchedulerJobService getSchedulerJobService() {
        return this.schedulerJobService;
    }

    @Generated
    public void setSchedulerJobService(SchedulerJobService schedulerJobService) {
        this.schedulerJobService = schedulerJobService;
    }

    @Generated
    public NotificationTemplateService getNotificationTemplateService() {
        return this.notificationTemplateService;
    }

    @Generated
    public void setNotificationTemplateService(NotificationTemplateService notificationTemplateService) {
        this.notificationTemplateService = notificationTemplateService;
    }
}

