/*
 * Decompiled with CFR 0.152.
 */
package goowee.document;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.pdf.PdfConverter;
import fr.opensagres.poi.xwpf.converter.pdf.PdfOptions;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.freemarker.FreemarkerTemplateEngine;
import goowee.commons.utils.FileUtils;
import goowee.document.DocumentGeneratorData;
import grails.artefact.Artefact;
import grails.gorm.multitenancy.CurrentTenant;
import grails.gorm.multitenancy.TenantService;
import grails.plugins.metadata.GrailsPlugin;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageProperties;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.xb.xmlschema.SpaceAttribute;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.gorm.internal.RuntimeSupport;
import org.grails.datastore.mapping.core.Datastore;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTMarkupRange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@CurrentTenant
@GrailsPlugin(name="gooweeDocument", version="1.x-SNAPSHOT")
@Artefact(value="Service")
public class DocumentGeneratorService
implements GroovyObject {
    private goowee.tenants.TenantService tenantService;
    private static final transient Logger log;
    protected Datastore $targetDatastore;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public DocumentGeneratorService() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    /*
     * WARNING - void declaration
     */
    public void generateDocument(OutputStream os, DocumentGeneratorData documentData) {
        void var2_2;
        Reference os2 = new Reference((Object)os);
        Reference documentData2 = new Reference((Object)var2_2);
        CallSite $tenantService = IndyInterface.bootstrap("cast", "()", 0, this.getTargetDatastore().getService(TenantService.class));
        public final class _generateDocument_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference os;
            private /* synthetic */ Reference documentData;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _generateDocument_closure1(Object _outerInstance, Object _thisObject, Reference os, Reference documentData) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.os = reference2 = os;
                this.documentData = reference = documentData;
            }

            public Object doCall(Serializable tenantId) {
                return InvokerHelper.invokeMethodSafe((Object)((DocumentGeneratorService)this.getThisObject()), (String)"$mt__generateDocument", (Object)new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.os.get()), IndyInterface.bootstrap("cast", "()", 0, this.documentData.get()), tenantId});
            }

            @Generated
            public Object call(Serializable tenantId) {
                return this.doCall(tenantId);
            }

            @Generated
            public OutputStream getOs() {
                return IndyInterface.bootstrap("cast", "()", 0, this.os.get());
            }

            @Generated
            public DocumentGeneratorData getDocumentData() {
                return IndyInterface.bootstrap("cast", "()", 0, this.documentData.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generateDocument_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        $tenantService.withCurrent(new _generateDocument_closure1(this, this, os2, documentData2));
    }

    /*
     * WARNING - void declaration
     */
    public void generateDocument(String documentPathname, DocumentGeneratorData documentData) {
        void var2_2;
        Reference documentPathname2 = new Reference((Object)documentPathname);
        Reference documentData2 = new Reference((Object)var2_2);
        CallSite $tenantService = IndyInterface.bootstrap("cast", "()", 0, this.getTargetDatastore().getService(TenantService.class));
        public final class _generateDocument_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference documentPathname;
            private /* synthetic */ Reference documentData;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _generateDocument_closure2(Object _outerInstance, Object _thisObject, Reference documentPathname, Reference documentData) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.documentPathname = reference2 = documentPathname;
                this.documentData = reference = documentData;
            }

            public Object doCall(Serializable tenantId) {
                return InvokerHelper.invokeMethodSafe((Object)((DocumentGeneratorService)this.getThisObject()), (String)"$mt__generateDocument", (Object)new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.documentPathname.get()), IndyInterface.bootstrap("cast", "()", 0, this.documentData.get()), tenantId});
            }

            @Generated
            public Object call(Serializable tenantId) {
                return this.doCall(tenantId);
            }

            @Generated
            public String getDocumentPathname() {
                return IndyInterface.bootstrap("cast", "()", 0, this.documentPathname.get());
            }

            @Generated
            public DocumentGeneratorData getDocumentData() {
                return IndyInterface.bootstrap("cast", "()", 0, this.documentData.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generateDocument_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        $tenantService.withCurrent(new _generateDocument_closure2(this, this, documentPathname2, documentData2));
    }

    public List listAvailableTemplates() {
        CallSite $tenantService = IndyInterface.bootstrap("cast", "()", 0, this.getTargetDatastore().getService(TenantService.class));
        public final class _listAvailableTemplates_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _listAvailableTemplates_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public List doCall(Serializable tenantId) {
                return IndyInterface.bootstrap("cast", "()", 0, InvokerHelper.invokeMethodSafe((Object)((DocumentGeneratorService)this.getThisObject()), (String)"$mt__listAvailableTemplates", (Object)new Object[]{tenantId}));
            }

            @Generated
            public List call(Serializable tenantId) {
                return this.doCall(tenantId);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _listAvailableTemplates_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return (List)$tenantService.withCurrent(new _listAvailableTemplates_closure3(this, this));
    }

    public String getTemplatesDir() {
        CallSite $tenantService = IndyInterface.bootstrap("cast", "()", 0, this.getTargetDatastore().getService(TenantService.class));
        public final class _getTemplatesDir_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getTemplatesDir_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(Serializable tenantId) {
                return IndyInterface.bootstrap("cast", "()", 0, InvokerHelper.invokeMethodSafe((Object)((DocumentGeneratorService)this.getThisObject()), (String)"$mt__getTemplatesDir", (Object)new Object[]{tenantId}));
            }

            @Generated
            public String call(Serializable tenantId) {
                return this.doCall(tenantId);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getTemplatesDir_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return (String)$tenantService.withCurrent(new _getTemplatesDir_closure4(this, this));
    }

    private String getLocalizedTemplate(DocumentGeneratorData documentData) {
        String template = documentData.getTemplate();
        CallSite localizedTemplate = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.compareNotEqual((Object)documentData.getLanguage(), (Object)"en") ? new GStringImpl(new Object[]{documentData.getTemplate(), documentData.getLanguage()}, new String[]{"", "_", ""}) : template);
        List list = this.listAvailableTemplates();
        return (list == null ? localizedTemplate == null : DefaultGroovyMethods.isCase((Collection)list, (Object)localizedTemplate)) ? localizedTemplate : template;
    }

    private ByteArrayOutputStream processTemplateFile(String inputPathname) {
        List list;
        FileInputStream is = new FileInputStream(inputPathname);
        XWPFDocument document = new XWPFDocument((InputStream)is);
        Integer imageNumber = 0;
        List list2 = document.getParagraphs();
        Iterator iterator = list2 != null ? list2.iterator() : null;
        CallSite paragraph = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                paragraph = IndyInterface.bootstrap("cast", "()", 0, iterator2.next());
                DocumentGeneratorService.mergeFreemarkerRuns((XWPFParagraph)paragraph, false);
                DocumentGeneratorService.addBookmarkToImages((XWPFParagraph)paragraph, imageNumber);
            }
        }
        Iterator iterator3 = (list = document.getTables()) != null ? list.iterator() : null;
        CallSite table = null;
        Iterator iterator4 = iterator3;
        if (iterator4 != null) {
            while (iterator4.hasNext()) {
                table = IndyInterface.bootstrap("cast", "()", 0, iterator4.next());
                List list3 = table.getRows();
                Iterator iterator5 = list3 != null ? list3.iterator() : null;
                CallSite row = null;
                Iterator iterator6 = iterator5;
                if (iterator6 == null) continue;
                while (iterator6.hasNext()) {
                    row = IndyInterface.bootstrap("cast", "()", 0, iterator6.next());
                    List list4 = row.getTableCells();
                    Iterator iterator7 = list4 != null ? list4.iterator() : null;
                    CallSite cell = null;
                    Iterator iterator8 = iterator7;
                    if (iterator8 == null) continue;
                    while (iterator8.hasNext()) {
                        cell = IndyInterface.bootstrap("cast", "()", 0, iterator8.next());
                        List list5 = cell.getParagraphs();
                        Iterator iterator9 = list5 != null ? list5.iterator() : null;
                        CallSite paragraph2 = null;
                        Iterator iterator10 = iterator9;
                        if (iterator10 == null) continue;
                        while (iterator10.hasNext()) {
                            paragraph2 = IndyInterface.bootstrap("cast", "()", 0, iterator10.next());
                            DocumentGeneratorService.mergeFreemarkerRuns((XWPFParagraph)paragraph2, true);
                            DocumentGeneratorService.addBookmarkToImages((XWPFParagraph)paragraph2, imageNumber);
                        }
                    }
                }
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        document.write((OutputStream)os);
        os.flush();
        os.close();
        document.close();
        return os;
    }

    private void processTemplateFile(String inputPathname, String outputPathName) {
        FileOutputStream os = new FileOutputStream(outputPathName);
        this.processTemplateFile(inputPathname).writeTo(os);
        os.flush();
        os.close();
    }

    private static ByteArrayOutputStream setDocxMetadata(ByteArrayOutputStream baos, DocumentGeneratorData data) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XWPFDocument document = new XWPFDocument((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        OPCPackage pkg = document.getPackage();
        PackageProperties props = pkg.getPackageProperties();
        String string = data.getTitle();
        if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
            props.setTitleProperty(data.getTitle());
        }
        String string2 = data.getCreator();
        if ((string2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string2)) != false) {
            props.setCreatorProperty(data.getCreator());
        }
        String string3 = data.getDescription();
        if ((string3 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string3)) != false) {
            props.setDescriptionProperty(data.getDescription());
        }
        String string4 = data.getSubject();
        if ((string4 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string4)) != false) {
            props.setSubjectProperty(data.getSubject());
        }
        String string5 = data.getKeywords();
        if ((string5 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string5)) != false) {
            props.setKeywordsProperty(data.getKeywords());
        }
        String string6 = data.getCategory();
        if ((string6 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string6)) != false) {
            props.setCategoryProperty(data.getCategory());
        }
        String string7 = data.getContentStatus();
        if ((string7 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string7)) != false) {
            props.setContentStatusProperty(data.getContentStatus());
        }
        String string8 = data.getRevision();
        if ((string8 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string8)) != false) {
            props.setRevisionProperty(data.getRevision());
        }
        document.write((OutputStream)os);
        os.flush();
        os.close();
        document.close();
        return os;
    }

    private static void setPdfMetadata(ByteArrayOutputStream baos, DocumentGeneratorData data, OutputStream os) {
        PdfReader reader = new PdfReader(baos.toByteArray());
        PdfStamper stamper = new PdfStamper(reader, os);
        HashMap<String, String> props = reader.getInfo();
        if (props == null) {
            props = new HashMap<String, String>();
        }
        String string = data.getTitle();
        if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
            props.put("Title", data.getTitle());
        }
        String string2 = data.getCreator();
        if ((string2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string2)) != false) {
            props.put("Creator", data.getCreator());
        }
        String string3 = data.getDescription();
        if ((string3 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string3)) != false) {
            props.put("Description", data.getDescription());
        }
        String string4 = data.getSubject();
        if ((string4 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string4)) != false) {
            props.put("Subject", data.getSubject());
        }
        String string5 = data.getKeywords();
        if ((string5 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string5)) != false) {
            props.put("Keywords", data.getKeywords());
        }
        String string6 = data.getCategory();
        if ((string6 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string6)) != false) {
            props.put("Category", data.getCategory());
        }
        String string7 = data.getContentStatus();
        if ((string7 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string7)) != false) {
            props.put("ContentStatus", data.getContentStatus());
        }
        String string8 = data.getRevision();
        if ((string8 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string8)) != false) {
            props.put("Revision", data.getRevision());
        }
        stamper.setInfoDictionary(props);
        stamper.close();
        reader.close();
    }

    private static void mergeFreemarkerRuns(XWPFParagraph para, Boolean mergeField) {
        List runs = para.getRuns();
        StringBuilder merged = new StringBuilder();
        int start = -1;
        int i = 0;
        while (i < runs.size()) {
            String text = ((XWPFRun)runs.get(i)).text();
            if (!(text == null)) {
                merged.append(text);
                if (text.contains("${") || text.contains("[#") || start >= 0) {
                    if (start == -1) {
                    }
                    if (text.contains("}") || text.contains("/#")) {
                        String placeholder = merged.toString().trim();
                        CallSite sourceRun = IndyInterface.bootstrap("cast", "()", 0, runs.get(start));
                        int j = start;
                        while (j <= i) {
                            ((XWPFRun)runs.get(j)).setText("", 0);
                            int n = j;
                            int cfr_ignored_0 = n + 1;
                        }
                        Boolean bl = mergeField;
                        if (bl == null ? false : bl) {
                            DocumentGeneratorService.insertMergeField(para, start, placeholder, (XWPFRun)sourceRun);
                            break;
                        }
                        ((XWPFRun)runs.get(start)).setText(placeholder, 0);
                        merged.setLength(0);
                        start = -1;
                    }
                }
            }
            int n = i;
            int cfr_ignored_1 = n + 1;
        }
    }

    private static void insertMergeField(XWPFParagraph para, int position, String fieldName, XWPFRun sourceRun) {
        int n = position;
        position = n + 1;
        XWPFRun runBegin = para.insertNewRun(n);
        DocumentGeneratorService.copyStyle(sourceRun, runBegin);
        CTR fldBegin = runBegin.getCTR();
        fldBegin.addNewFldChar().setFldCharType(STFldCharType.BEGIN);
        int n2 = position;
        position = n2 + 1;
        XWPFRun runInstr = para.insertNewRun(n2);
        DocumentGeneratorService.copyStyle(sourceRun, runInstr);
        CTR instr = runInstr.getCTR();
        instr.addNewInstrText().setStringValue(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)" MERGEFIELD ", (CharSequence)fieldName), (CharSequence)" "));
        instr.getInstrTextArray(0).setSpace(SpaceAttribute.Space.PRESERVE);
        int n3 = position;
        position = n3 + 1;
        XWPFRun runSep = para.insertNewRun(n3);
        DocumentGeneratorService.copyStyle(sourceRun, runSep);
        CTR fldSep = runSep.getCTR();
        fldSep.addNewFldChar().setFldCharType(STFldCharType.SEPARATE);
        int n4 = position;
        position = n4 + 1;
        XWPFRun runText = para.insertNewRun(n4);
        DocumentGeneratorService.copyStyle(sourceRun, runText);
        runText.setText(fieldName);
        XWPFRun runEnd = para.insertNewRun(position);
        DocumentGeneratorService.copyStyle(sourceRun, runEnd);
        CTR fldEnd = runEnd.getCTR();
        fldEnd.addNewFldChar().setFldCharType(STFldCharType.END);
    }

    private static void copyStyle(XWPFRun source, XWPFRun target) {
        target.setBold(source.isBold());
        target.setItalic(source.isItalic());
        target.setStrikeThrough(source.isStrikeThrough());
        target.setUnderline(source.getUnderline());
        target.setColor(source.getColor());
        target.setFontFamily(source.getFontFamily());
        Double fontSize = source.getFontSizeAsDouble();
        Double d = fontSize;
        if ((d == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, d)) != false) {
            target.setFontSize(fontSize.intValue());
        }
        target.setTextPosition(source.getTextPosition());
    }

    private static Integer addBookmarkToImages(XWPFParagraph para, Integer imageNumber) {
        List runs = para.getRuns();
        int i = 0;
        while (i < runs.size()) {
            CallSite run = IndyInterface.bootstrap("cast", "()", 0, runs.get(i));
            List pictures = run.getEmbeddedPictures();
            if (!pictures.isEmpty()) {
                imageNumber = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.next((Number)imageNumber));
                CTP ctp = para.getCTP();
                CTBookmark bookmarkStart = ctp.insertNewBookmarkStart(0);
                bookmarkStart.setId(DefaultGroovyMethods.toBigInteger((Number)imageNumber));
                bookmarkStart.setName((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{imageNumber}, new String[]{"image", ""}))));
                XWPFRun runTo = para.createRun();
                CTR ctrFrom = run.getCTR();
                CTR ctrTo = runTo.getCTR();
                CTDrawing drawingFrom = ctrFrom.getDrawingArray(0);
                CallSite drawingTo = IndyInterface.bootstrap("cast", "()", 0, drawingFrom.copy());
                ctrFrom.removeDrawing(0);
                ctrTo.addNewDrawing().set((XmlObject)drawingTo);
                CTMarkupRange bookmarkEnd = ctp.insertNewBookmarkEnd(0);
                bookmarkEnd.setId(DefaultGroovyMethods.toBigInteger((Number)imageNumber));
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return imageNumber;
    }

    @Generated
    @Autowired(required=false)
    public void setTargetDatastore(Datastore ... datastores) {
        Datastore datastore;
        this.$targetDatastore = datastore = RuntimeSupport.findDefaultDatastore((Datastore[])datastores);
    }

    @Generated
    protected Datastore getTargetDatastore(String connectionName) {
        if (this.$targetDatastore != null) {
            return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.invokeMethodN(DocumentGeneratorService.class, (Object)this.$targetDatastore, (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}));
        }
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.invokeMethodN(DocumentGeneratorService.class, (Object)GormEnhancer.findSingleDatastore(), (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}));
    }

    @Generated
    protected Datastore getTargetDatastore() {
        if (this.$targetDatastore != null) {
            return this.$targetDatastore;
        }
        return GormEnhancer.findSingleDatastore();
    }

    protected void $mt__generateDocument(OutputStream os, DocumentGeneratorData documentData, Serializable tenantId) {
        CallSite templatePathname = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{this.getTemplatesDir(), this.getLocalizedTemplate(documentData)}, new String[]{"", "/", ".docx"}));
        ByteArrayOutputStream ostmp = this.processTemplateFile((String)((Object)templatePathname));
        Boolean bl = documentData.getPdf();
        if (!(bl == null ? false : bl) && DefaultTypeTransformation.booleanUnbox((Object)documentData.getHasMetadata())) {
            ostmp = DocumentGeneratorService.setDocxMetadata(ostmp, documentData);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(ostmp.toByteArray());
        IXDocReport document = XDocReportRegistry.getRegistry().loadReport((InputStream)is, TemplateEngineKind.Freemarker);
        FieldsMetadata metadata = document.createFieldsMetadata();
        IContext context = document.createContext();
        Object field = null;
        Iterator iterator = DefaultGroovyMethods.iterator(documentData.fields);
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string;
                field = iterator.next();
                StringEscapeUtils.escapeXml10((String)((String)((Map.Entry)field).getValue()).toString());
                ((Map.Entry)field).setValue(string);
                context.put((String)((Object)IndyInterface.bootstrap("cast", "()", 0, ((Map.Entry)field).getKey())), ((Map.Entry)field).getValue());
            }
        }
        Object table = null;
        Iterator iterator2 = DefaultGroovyMethods.iterator(documentData.tables);
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                table = iterator2.next();
                Object v = ((Map.Entry)table).getValue();
                if ((v == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v)) == false) continue;
                Object record = null;
                Object v2 = ((Map.Entry)table).getValue();
                Iterator iterator3 = v2 != null ? ((List)v2).iterator() : null;
                if (iterator3 != null) {
                    while (iterator3.hasNext()) {
                        record = iterator3.next();
                        Object field2 = null;
                        Iterator iterator4 = DefaultGroovyMethods.iterator((Object)record);
                        if (iterator4 == null) continue;
                        while (iterator4.hasNext()) {
                            String string;
                            field2 = iterator4.next();
                            StringEscapeUtils.escapeXml10((String)DefaultGroovyMethods.toString(((Map.Entry)field2).getValue()));
                            ((Map.Entry)field2).setValue(string);
                            metadata.addFieldAsList((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{((Map.Entry)table).getKey(), ((Map.Entry)field2).getKey()}, new String[]{"", ".", ""}))));
                        }
                    }
                }
                context.put((String)((Object)IndyInterface.bootstrap("cast", "()", 0, ((Map.Entry)table).getKey())), ((Map.Entry)table).getValue());
            }
        }
        Object image = null;
        Iterator iterator5 = DefaultGroovyMethods.iterator(documentData.images);
        if (iterator5 != null) {
            while (iterator5.hasNext()) {
                image = iterator5.next();
                metadata.addFieldAsImage((String)((Object)IndyInterface.bootstrap("cast", "()", 0, ((Map.Entry)image).getKey())));
                context.put((String)((Object)IndyInterface.bootstrap("cast", "()", 0, ((Map.Entry)image).getKey())), ((Map.Entry)image).getValue());
            }
        }
        document.setTemplateEngine((ITemplateEngine)new FreemarkerTemplateEngine());
        document.setFieldsMetadata(metadata);
        Boolean bl2 = documentData.getPdf();
        if (bl2 == null ? false : bl2) {
            ostmp = new ByteArrayOutputStream();
            document.process(context, (OutputStream)ostmp);
            is = new ByteArrayInputStream(ostmp.toByteArray());
            PdfOptions options = PdfOptions.create();
            Boolean bl3 = documentData.getHasMetadata();
            if (bl3 == null ? false : bl3) {
                ostmp = new ByteArrayOutputStream();
                PdfConverter.getInstance().convert(new XWPFDocument((InputStream)is), (OutputStream)ostmp, (Options)options);
                DocumentGeneratorService.setPdfMetadata(ostmp, documentData, os);
            } else {
                PdfConverter.getInstance().convert(new XWPFDocument((InputStream)is), os, (Options)options);
            }
        } else {
            document.process(context, os);
        }
    }

    protected void $mt__generateDocument(String documentPathname, DocumentGeneratorData documentData, Serializable tenantId) {
        FileOutputStream os = new FileOutputStream(new File(documentPathname));
        this.generateDocument(os, documentData);
    }

    protected List $mt__listAvailableTemplates(Serializable tenantId) {
        String preparedTemplatesDir = this.getTemplatesDir();
        List templates = FileUtils.listFiles((String)preparedTemplatesDir, (String)"*.docx");
        public final class __mt__listAvailableTemplates_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __mt__listAvailableTemplates_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(Object it) {
                return FileUtils.removeExtension((String)((Object)IndyInterface.bootstrap("cast", "()", 0, it)));
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public String doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __mt__listAvailableTemplates_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return DefaultGroovyMethods.collect((Iterable)((Object)IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getPropertySpreadSafe(DocumentGeneratorService.class, (Object)templates, (String)"name"))), (Closure)new __mt__listAvailableTemplates_closure5(this, this));
    }

    protected String $mt__getTemplatesDir(Serializable tenantId) {
        return StringGroovyMethods.plus((String)this.tenantService.getPrivateDir(), (CharSequence)"document/templates/");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DocumentGeneratorService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"goowee.document.DocumentGeneratorService");
    }

    @Generated
    public goowee.tenants.TenantService getTenantService() {
        return this.tenantService;
    }

    @Generated
    public void setTenantService(goowee.tenants.TenantService tenantService) {
        this.tenantService = tenantService;
    }
}

