/*
 * Decompiled with CFR 0.152.
 */
package goowee.document;

import fr.opensagres.xdocreport.document.images.ByteArrayImageProvider;
import goowee.commons.utils.BarcodeUtils;
import goowee.commons.utils.ImageUtils;
import goowee.commons.utils.ImageUtilsFormat;
import goowee.exceptions.GooweeException;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.awt.image.BufferedImage;
import java.beans.Transient;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class DocumentGeneratorData
implements GroovyObject {
    protected Map<String, String> fields;
    protected Map<String, List<Map<String, String>>> tables;
    protected Map<String, ByteArrayImageProvider> images;
    private String template;
    private String language;
    private Boolean hasMetadata;
    private String title;
    private String creator;
    private String description;
    private String subject;
    private String keywords;
    private String category;
    private String contentStatus;
    private String revision;
    private Boolean pdf;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public DocumentGeneratorData(String template, String language) {
        String string;
        String string2;
        MetaClass metaClass;
        Map map;
        Map map2;
        Map map3;
        this.fields = map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.tables = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.images = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        boolean bl = false;
        this.hasMetadata = bl;
        boolean bl2 = true;
        this.pdf = bl2;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.template = string2 = template;
        this.language = string = language;
    }

    @Generated
    public DocumentGeneratorData(String template) {
        this(template, "en");
    }

    public String getTemplate() {
        return this.template;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setFields(Map<String, String> fields) {
        this.verifyTypes(fields);
        Map<String, String> map = fields;
        this.fields = map;
    }

    public void addField(String name, String value) {
        String string = value.toString();
        ScriptBytecodeAdapter.invokeMethodN(DocumentGeneratorData.class, this.fields, (String)"putAt", (Object[])new Object[]{name, string});
    }

    public void addTable(String name, List<Map<String, String>> recordset) {
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        ScriptBytecodeAdapter.invokeMethodN(DocumentGeneratorData.class, this.tables, (String)"putAt", (Object[])new Object[]{name, list});
        List<Map<String, String>> list2 = recordset;
        Map<String, String> record = null;
        Iterator<Map<String, String>> iterator = list2 != null ? list2.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                record = iterator.next();
                this.addTableRecord(name, (Map<String, String>)((Object)IndyInterface.bootstrap("cast", "()", 0, record)));
            }
        }
    }

    private void addTableRecord(String table, Map<String, String> record) {
        this.verifyTypes(record);
        ((List)DefaultGroovyMethods.getAt(this.tables, (Object)table)).add(record);
    }

    private Object verifyTypes(Map map) {
        Object item = null;
        Iterator iterator = DefaultGroovyMethods.iterator((Object)map);
        if (iterator != null) {
            while (iterator.hasNext()) {
                item = iterator.next();
                if (!DefaultGroovyMethods.isNotCase(String.class, ((Map.Entry)item).getValue())) continue;
                throw (Throwable)new GooweeException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{((Map.Entry)item).getKey(), ((Map.Entry)item).getValue().getClass().getName()}, new String[]{"Field '", "' must be of type java.lang.String, is '", "'"}))));
            }
        }
        return null;
    }

    public void addImageEAN13(String name, String code, Integer width, Integer height) {
        BufferedImage image = BarcodeUtils.generateEAN13((String)code, (Integer)width, (Integer)height);
        this.addImage(name, image);
    }

    public void addImageUPCA(String name, String code, Integer width, Integer height) {
        BufferedImage image = BarcodeUtils.generateUPCA((String)code, (Integer)width, (Integer)height);
        this.addImage(name, image);
    }

    public void addImageCode128(String name, String code, Integer width, Integer height) {
        BufferedImage image = BarcodeUtils.generateCode128((String)code, (Integer)width, (Integer)height);
        this.addImage(name, image);
    }

    public void addImageITF(String name, String code, Integer width, Integer height) {
        BufferedImage image = BarcodeUtils.generateITF((String)code, (Integer)width, (Integer)height);
        this.addImage(name, image);
    }

    public void addImageDataMatrix(String name, String code, Integer width, Integer height) {
        BufferedImage image = BarcodeUtils.generateDataMatrix((String)code, (Integer)width, (Integer)height);
        this.addImage(name, image);
    }

    public void addImageQRCode(String name, String code, Integer width, Integer height) {
        BufferedImage image = BarcodeUtils.generateQRCode((String)code, (Integer)width, (Integer)height);
        this.addImage(name, image);
    }

    public void addImageScaleWidth(String name, String imagePathname, Integer width) {
        BufferedImage image = ImageUtils.load((String)imagePathname);
        BufferedImage resizedImage = ImageUtils.scaleWidth((BufferedImage)image, (Integer)width);
        this.addImage(name, resizedImage, (Boolean)true);
    }

    public void addImageScaleHeight(String name, String imagePathname, Integer height) {
        BufferedImage image = ImageUtils.load((String)imagePathname);
        BufferedImage resizedImage = ImageUtils.scaleHeight((BufferedImage)image, (Integer)height);
        this.addImage(name, resizedImage, (Boolean)true);
    }

    public void addImage(String name, String imagePathname, Integer width, Integer height) {
        BufferedImage image = ImageUtils.load((String)imagePathname);
        BufferedImage resizedImage = ImageUtils.resize((BufferedImage)image, (Integer)width, (Integer)height);
        this.addImage(name, resizedImage, (Boolean)true);
    }

    public void addImage(String name, String imagePathname, Boolean originalSize) {
        BufferedImage image = ImageUtils.load((String)imagePathname);
        this.addImage(name, image, originalSize);
    }

    public void addImage(String name, BufferedImage image, Boolean originalSize) {
        byte[] imageBytes = ImageUtils.toByteArray((BufferedImage)image, (ImageUtilsFormat)ImageUtilsFormat.PNG);
        ByteArrayImageProvider imageProvider = new ByteArrayImageProvider(imageBytes);
        Boolean bl = originalSize;
        if (bl == null ? false : bl) {
            imageProvider.setSize((Float)((Object)IndyInterface.bootstrap("cast", "()", 0, image.getWidth())), (Float)((Object)IndyInterface.bootstrap("cast", "()", 0, image.getHeight())));
        }
        ByteArrayImageProvider byteArrayImageProvider = imageProvider;
        ScriptBytecodeAdapter.invokeMethodN(DocumentGeneratorData.class, this.images, (String)"putAt", (Object[])new Object[]{name, byteArrayImageProvider});
    }

    public Boolean getHasMetadata() {
        return this.hasMetadata;
    }

    public void setTitle(String title) {
        String string;
        this.title = string = title;
        boolean bl = true;
        this.hasMetadata = bl;
    }

    public void setCreator(String creator) {
        String string;
        this.creator = string = creator;
        boolean bl = true;
        this.hasMetadata = bl;
    }

    public void setDescription(String description) {
        String string;
        this.description = string = description;
        boolean bl = true;
        this.hasMetadata = bl;
    }

    public void setSubject(String subject) {
        String string;
        this.subject = string = subject;
        boolean bl = true;
        this.hasMetadata = bl;
    }

    public void setKeywords(String keywords) {
        String string;
        this.keywords = string = keywords;
        boolean bl = true;
        this.hasMetadata = bl;
    }

    public void setCategory(String category) {
        String string;
        this.category = string = category;
        boolean bl = true;
        this.hasMetadata = bl;
    }

    public void setContentStatus(String contentStatus) {
        String string;
        this.contentStatus = string = contentStatus;
        boolean bl = true;
        this.hasMetadata = bl;
    }

    public void setRevision(String revision) {
        String string;
        this.revision = string = revision;
        boolean bl = true;
        this.hasMetadata = bl;
    }

    @Generated
    public void addImage(String name, String imagePathname) {
        this.addImage(name, imagePathname, (Boolean)false);
    }

    @Generated
    public void addImage(String name, BufferedImage image) {
        this.addImage(name, image, (Boolean)false);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DocumentGeneratorData.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getCreator() {
        return this.creator;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Generated
    public String getKeywords() {
        return this.keywords;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public String getContentStatus() {
        return this.contentStatus;
    }

    @Generated
    public String getRevision() {
        return this.revision;
    }

    @Generated
    public Boolean getPdf() {
        return this.pdf;
    }

    @Generated
    public void setPdf(Boolean bl) {
        this.pdf = bl;
    }
}

