/*
 * Decompiled with CFR 0.152.
 */
package goowee.commons.tokenizer.api;

import goowee.commons.tokenizer.api.TokenizerException;
import goowee.commons.tokenizer.api.model.FieldLayout;
import goowee.commons.tokenizer.api.model.RecordLayout;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.GroovyCastException;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldSerializer
implements GroovyObject {
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public FieldSerializer() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public String serialize(RecordLayout record, FieldLayout field, Object value) {
        this.setFieldDefaults(record, field);
        Object processedValue = this.processFieldValue(record, field, value);
        String serializedValue = null;
        String string = field.getType();
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"S", "A"}))) {
            serializedValue = this.serializeString(record, field, processedValue);
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"I", "N"}))) {
            serializedValue = this.serializeInteger(record, field, processedValue);
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"F")) {
            serializedValue = this.serializeFloat(record, field, processedValue);
        } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"D")) {
            serializedValue = this.serializeDate(record, field, processedValue);
        } else {
            throw (Throwable)new TokenizerException(record, field, StringGroovyMethods.plus((String)"There's something strange in you neighborhood, ", (CharSequence)"who you gonna call? Ghostbusters!"));
        }
        return this.truncate(serializedValue, field);
    }

    private Object processFieldValue(RecordLayout record, FieldLayout field, Object value) {
        Object result = value;
        if (value == null && field.getDefaultValue() != null) {
            result = ScriptBytecodeAdapter.compareEqual((Object)field.getDefaultValue(), (Object)"_blank") ? " " : field.getDefaultValue();
        } else if (value == null && DefaultTypeTransformation.booleanUnbox((Object)field.getNullable())) {
            result = "";
        } else if (value == null) {
            throw (Throwable)new TokenizerException(record, field, "Trying to serialize a 'null' value but 'nullable' is set to 'false'");
        }
        return result;
    }

    private String serializeString(RecordLayout record, FieldLayout field, Object value) {
        Integer n = field.getLength();
        if ((n == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, n)) == false) {
            return (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, value, String.class));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)field.getAlign(), (Object)Character.valueOf('R'))) {
            return StringGroovyMethods.padLeft((CharSequence)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, value, String.class))), (Number)field.getLength(), (CharSequence)field.getFiller());
        }
        return StringGroovyMethods.padRight((CharSequence)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, value, String.class))), (Number)field.getLength(), (CharSequence)field.getFiller());
    }

    private String serializeInteger(RecordLayout record, FieldLayout field, Object value) {
        String string = field.getAlign();
        String string2 = IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : "R";
        field.setAlign(string2);
        String string3 = field.getFiller();
        String string4 = IndyInterface.bootstrap("cast", "()", 0, string3) != false ? string3 : "0";
        field.setFiller(string4);
        return this.serializeString(record, field, value);
    }

    private String serializeDate(RecordLayout record, FieldLayout field, Object value) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(field.getFormat());
        if (DefaultGroovyMethods.isCase(String.class, (Object)value)) {
            value = dateFormat.parse((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, value, String.class)));
        } else if (DefaultGroovyMethods.isNotCase(Date.class, (Object)value)) {
            throw (Throwable)new TokenizerException(record, field, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{value.getClass()}, new String[]{"Cannot serialize type '", "', try with String or Date."}))));
        }
        String string = dateFormat.format(value);
        try {
            return string;
        }
        catch (ParseException ignored) {
            throw (Throwable)new TokenizerException(record, field, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{value}, new String[]{"Value '", "' is not a date."}))));
        }
    }

    private String serializeFloat(RecordLayout record, FieldLayout field, Object value) {
        Double doubleValue = null;
        try {
            doubleValue = (Double)((Object)IndyInterface.bootstrap("invoke", "asType", 0, value, Double.class));
        }
        catch (GroovyCastException e) {
            throw (Throwable)new TokenizerException(record, field, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{value}, new String[]{"Value '", "' is not a valid number."}))));
        }
        String stringValue = this.formatNumber(record, field, doubleValue);
        return this.serializeString(record, field, stringValue);
    }

    private String formatNumber(RecordLayout record, FieldLayout field, Double value) {
        Integer decimalPrecision = field.getDecimalPrecision();
        Boolean decimalRounding = field.getDecimalRounding();
        String groupingSeparator = field.getGroupingSeparator();
        String decimalSeparator = field.getDecimalSeparator();
        String decimalPattern = StringGroovyMethods.multiply((CharSequence)"0", (Number)DefaultGroovyMethods.abs((Number)decimalPrecision));
        String string = groupingSeparator;
        String numberPattern = (string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false ? "#,###" : "#";
        String string2 = decimalPattern;
        String pattern = StringGroovyMethods.plus((String)numberPattern, (CharSequence)((string2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string2)) != false ? StringGroovyMethods.plus((String)".", (CharSequence)decimalPattern) : ""));
        Integer decimalsInValue = this.countDecimalsInValue(value);
        Boolean bl = decimalRounding;
        if (!(bl == null ? false : bl) && ScriptBytecodeAdapter.compareGreaterThan((Object)decimalsInValue, (Object)decimalPrecision)) {
            throw (Throwable)new TokenizerException(record, field, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{value, decimalsInValue, DefaultGroovyMethods.abs((Number)decimalPrecision)}, new String[]{"Cannot serialize value '", "' with '", "' decimals into a string format with '", "' decimals when 'decimalRounding' is set to 'false'."}))));
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        String string3 = groupingSeparator;
        if ((string3 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string3)) != false) {
            Character c = (Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, groupingSeparator, Character.class));
            symbols.setGroupingSeparator(c.charValue());
        }
        Character c = (Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, decimalSeparator, Character.class));
        symbols.setDecimalSeparator(c.charValue());
        DecimalFormat df = new DecimalFormat(pattern, symbols);
        String string4 = groupingSeparator;
        if ((string4 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string4)) == false) {
            boolean bl2 = false;
            df.setGroupingUsed(bl2);
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        Boolean bl3 = decimalRounding;
        RoundingMode rounding = (bl3 == null ? false : bl3) ? RoundingMode.HALF_UP : RoundingMode.HALF_DOWN;
        bd = bd.setScale((int)decimalPrecision, rounding);
        return df.format(bd.doubleValue());
    }

    private Integer countDecimalsInValue(Double value) {
        Object[] part = value.toString().split("\\.");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)BytecodeInterface8.objectArrayGet((Object[])part, (int)1), (Object)Character.valueOf('0'))) {
            return ((String)BytecodeInterface8.objectArrayGet((Object[])part, (int)1)).length();
        }
        return 0;
    }

    private void setFieldDefaults(RecordLayout record, FieldLayout field) {
        String string;
        Integer n = field.getDecimalPrecision();
        Integer n2 = IndyInterface.bootstrap("cast", "()", 0, n) != false ? n : record.getDecimalPrecision();
        field.setDecimalPrecision(n2);
        Boolean bl = field.getDecimalRounding();
        Boolean bl2 = IndyInterface.bootstrap("cast", "()", 0, bl) != false ? bl : record.getDecimalRounding();
        field.setDecimalRounding(bl2);
        String string2 = field.getDecimalSeparator();
        String string3 = IndyInterface.bootstrap("cast", "()", 0, string2) != false ? string2 : record.getDecimalSeparator();
        field.setDecimalSeparator(string3);
        String string4 = field.getGroupingSeparator();
        String string5 = IndyInterface.bootstrap("cast", "()", 0, string4) != false ? string4 : record.getGroupingSeparator();
        field.setGroupingSeparator(string5);
        Boolean bl3 = field.getTruncate() == null ? Boolean.valueOf(true) : field.getTruncate();
        field.setTruncate(bl3);
        Boolean bl4 = field.getNullable() == null ? Boolean.valueOf(true) : field.getNullable();
        field.setNullable(bl4);
        String string6 = ScriptBytecodeAdapter.compareEqual((Object)field.getFiller(), (Object)"_blank") ? " " : (IndyInterface.bootstrap("cast", "()", 0, string = field.getFiller()) != false ? string : " ");
        field.setFiller(string6);
        String string7 = field.getAlign();
        String string8 = IndyInterface.bootstrap("cast", "()", 0, string7) != false ? string7 : "L";
        field.setAlign(string8);
    }

    private String truncate(String value, FieldLayout field) {
        Integer n = field.getLength();
        if ((n == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, n)) == false) {
            return value;
        }
        Boolean bl = field.getTruncate();
        if (!(bl == null ? false : bl) || ScriptBytecodeAdapter.compareGreaterThanEqual((Object)field.getLength(), (Object)value.length())) {
            return value;
        }
        return value.substring(0, field.getLength());
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FieldSerializer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"goowee.commons.tokenizer.api.FieldSerializer");
    }
}

