/*
 * Decompiled with CFR 0.152.
 */
package goowee.commons.tokenizer.api;

import goowee.commons.tokenizer.api.TokenizerException;
import goowee.commons.tokenizer.api.model.FieldLayout;
import goowee.commons.tokenizer.api.model.RecordLayout;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class FieldDeserializer
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public FieldDeserializer() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Object deserialize(RecordLayout record, FieldLayout layout, String stringValue) {
        Object value;
        block1: {
            String string;
            block3: {
                block2: {
                    block0: {
                        value = null;
                        string = layout.getType();
                        if (!ScriptBytecodeAdapter.isCase((Object)string, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"S", "A"}))) break block0;
                        value = this.deserializeString(record, layout, stringValue);
                        break block1;
                    }
                    if (!ScriptBytecodeAdapter.isCase((Object)string, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"I", "N"}))) break block2;
                    value = this.deserializeNumber(record, layout, stringValue);
                    break block1;
                }
                if (!ScriptBytecodeAdapter.isCase((Object)string, (Object)"F")) break block3;
                value = this.deserializeFloat(record, layout, stringValue);
                break block1;
            }
            if (!ScriptBytecodeAdapter.isCase((Object)string, (Object)"D")) break block1;
            value = this.deserializeDate(record, layout, stringValue);
        }
        return value;
    }

    private String deserializeString(RecordLayout record, FieldLayout field, String stringValue) {
        String value = stringValue.trim();
        return value;
    }

    private Long deserializeNumber(RecordLayout record, FieldLayout field, String stringValue) {
        String trimmedValue = stringValue.trim();
        String string = trimmedValue;
        if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Long value = null;
        try {
            value = (Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, trimmedValue, Long.class));
        }
        catch (Exception e) {
            throw (Throwable)new TokenizerException(record, field, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{stringValue}, new String[]{"Value '", "' is not a number."}))));
        }
        return value;
    }

    private Double deserializeFloat(RecordLayout record, FieldLayout field, String stringValue) {
        String trimmedValue = stringValue.trim();
        String string = trimmedValue;
        if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Double value = null;
        try {
            String normalizedValue = this.normalizeNumber(record, field, trimmedValue);
            value = (Double)((Object)IndyInterface.bootstrap("invoke", "asType", 0, normalizedValue, Double.class));
        }
        catch (Exception e) {
            throw (Throwable)new TokenizerException(record, field, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{stringValue}, new String[]{"Value '", "' is not a number."}))));
        }
        return value;
    }

    private Date deserializeDate(RecordLayout record, FieldLayout field, String stringValue) {
        Date value = null;
        try {
            value = new SimpleDateFormat(field.getFormat()).parse(stringValue);
        }
        catch (Exception e) {
            throw (Throwable)new TokenizerException(record, field, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{stringValue}, new String[]{"Cannot convert value '", "' to Date."}))));
        }
        return value;
    }

    private String normalizeNumber(RecordLayout record, FieldLayout field, String number) {
        String string = field.getGroupingSeparator();
        String groupMark = IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : record.getGroupingSeparator();
        String string2 = field.getDecimalSeparator();
        String decimalMark = IndyInterface.bootstrap("cast", "()", 0, string2) != false ? string2 : record.getDecimalSeparator();
        if (ScriptBytecodeAdapter.compareEqual((Object)groupMark, (Object)Character.valueOf('.'))) {
            groupMark = "\\.";
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)decimalMark, (Object)Character.valueOf('.'))) {
            decimalMark = "\\.";
        }
        String result = number;
        String string3 = groupMark;
        if ((string3 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string3)) != false) {
            result = result.replaceAll(groupMark, "");
        }
        return result.replaceAll(decimalMark, ".");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FieldDeserializer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }
}

