/*
 * Decompiled with CFR 0.152.
 */
package goowee.commons.importexport;

import goowee.commons.utils.LogUtils;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportUtils
implements GroovyObject {
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public ImportUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static void fromCsv(String filename, List<String> columns, Map importProperties, Closure importer) {
        if (log.isInfoEnabled()) {
            log.info((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{filename}, new String[]{"IMPORTING FILE '", "'"}))));
            v0 = null;
        } else {
            v0 = null;
        }
        ImportUtils.fromCsv(ImportUtils.inputStreamFromFilename(filename), columns, importProperties, importer);
    }

    public static List<String> columnsFromCsv(String filename, Map importProperties) {
        ImportUtils.initializeCsvImportProperties(importProperties);
        String delimiter = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, importProperties.get("delimiter"), String.class));
        Character quote = (Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, importProperties.get("quote"), Character.class));
        FileInputStream is = ImportUtils.inputStreamFromFilename(filename);
        InputStreamReader reader = new InputStreamReader(is);
        CSVFormat csvFormat = CSVFormat.Builder.create().setDelimiter(delimiter).setQuote(quote).setRecordSeparator("\r\n").setIgnoreEmptyLines(true).get();
        CallSite columns = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        CSVParser records = csvFormat.parse((Reader)reader);
        CallSite record = IndyInterface.bootstrap("cast", "()", 0, records.iterator().next());
        ((ArrayList)((Object)columns)).addAll(record.toList());
        is.close();
        return columns;
    }

    public static void fromCsv(String filename, Map importProperties, Closure importer) {
        List<String> columns = ImportUtils.columnsFromCsv(filename, importProperties);
        ImportUtils.fromCsv(filename, columns, importProperties, importer);
    }

    public static void fromCsv(InputStream is, List<String> columns, Map importProperties, Closure importer) {
        ImportUtils.initializeCsvImportProperties(importProperties);
        Integer startAt = (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, importProperties.get("startAt"), Integer.class));
        Integer stopAt = (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, importProperties.get("stopAt"), Integer.class));
        CallSite delimiter = IndyInterface.bootstrap("cast", "()", 0, importProperties.get("delimiter"));
        Character quote = (Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, importProperties.get("quote"), Character.class));
        if (log.isInfoEnabled()) {
            log.info((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{delimiter, quote, startAt}, new String[]{"Reading CSV with delimiter: '", "', quote: '", "', starting at line: '", "'"}))));
            v0 = null;
        } else {
            v0 = null;
        }
        InputStreamReader reader = new InputStreamReader(is);
        CSVFormat csvFormat = CSVFormat.Builder.create().setDelimiter((String)((Object)delimiter)).setQuote(quote).setRecordSeparator("\r\n").setIgnoreEmptyLines(true).get();
        StopWatch sw = new StopWatch();
        sw.start();
        Object line = 1;
        Object success = 0;
        Object error = 0;
        CSVParser records = csvFormat.parse((Reader)reader);
        CSVParser cSVParser = records;
        Object record = null;
        Iterator iterator = cSVParser != null ? cSVParser.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                record = iterator.next();
                if (ScriptBytecodeAdapter.compareLessThan((Object)line, (Object)startAt)) {
                    line = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.next((Number)line));
                    continue;
                }
                CallSite rowToImport = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                Object colPosition = 0;
                String column = null;
                List<String> list = columns;
                Iterator<String> iterator2 = list != null ? list.iterator() : null;
                if (iterator2 != null) {
                    while (iterator2.hasNext()) {
                        column = iterator2.next();
                        if (ScriptBytecodeAdapter.compareGreaterThan((Object)colPosition, (Object)(((CSVRecord)record).size() - 1))) {
                            Object v1;
                            if (log.isErrorEnabled()) {
                                log.error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{columns.size(), ((CSVRecord)record).size()}, new String[]{"Expecting ", " columns but row contains ", " columns"}))));
                                v1 = null;
                                continue;
                            }
                            v1 = null;
                            continue;
                        }
                        String string = ((CSVRecord)record).get(((Integer)colPosition).intValue());
                        ScriptBytecodeAdapter.invokeMethodN(ImportUtils.class, (Object)rowToImport, (String)"putAt", (Object[])new Object[]{column, string});
                        colPosition = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.next((Number)colPosition));
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{rowToImport}, new String[]{"PROCESSING ROW: ", ""}))));
                    v2 = null;
                } else {
                    v2 = null;
                }
                try {
                    importer.call((Object)rowToImport);
                    success = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.next((Number)success));
                }
                catch (Exception e) {
                    ImportUtils.logError((Integer)line, (Map)((Object)rowToImport), importProperties, e);
                    error = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.next((Number)error));
                }
                line = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.next((Number)line));
                if (!(ScriptBytecodeAdapter.compareGreaterThan((Object)stopAt, (Object)0) && ScriptBytecodeAdapter.compareGreaterThan((Object)line, (Object)stopAt))) continue;
                break;
            }
        }
        is.close();
        sw.stop();
        if (log.isInfoEnabled()) {
            log.info((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{line, sw.toString(), success, error}, new String[]{"IMPORTED ", " ROWS IN ", " (SUCCESS: ", ", ERROR: ", ""}))));
            v3 = null;
        } else {
            v3 = null;
        }
    }

    private static void initializeCsvImportProperties(Map importProperties) {
        String string;
        Object object;
        Object object2;
        Object v = importProperties.get("startAt");
        Object object3 = object2 = IndyInterface.bootstrap("cast", "()", 0, v) != false ? v : Integer.valueOf(2);
        importProperties.put("startAt", object3);
        Object v2 = importProperties.get("stopAt");
        Object object4 = object = IndyInterface.bootstrap("cast", "()", 0, v2) != false ? v2 : Integer.valueOf(0);
        importProperties.put("stopAt", object4);
        String string2 = string = importProperties.get("delimiter") == null ? CSVFormat.DEFAULT.getDelimiterString() : importProperties.get("delimiter");
        importProperties.put("delimiter", string2);
        if (!importProperties.containsKey("quote")) {
            Character c;
            Character c2 = c = CSVFormat.DEFAULT.getQuoteCharacter();
            importProperties.put("quote", c2);
        } else {
            Object v3 = importProperties.get("quote");
            if ((v3 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v3)) == false) {
                Object v4;
                Object v5 = v4 = null;
                importProperties.put("quote", v5);
            } else {
                Character c;
                Character c3 = c = (Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, importProperties.get("quote"), Character.class));
                importProperties.put("quote", c3);
            }
        }
    }

    public static void fromExcel(String filename, List<String> columns, Map importProperties, Closure importer) {
        if (log.isInfoEnabled()) {
            log.info((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{filename}, new String[]{"IMPORTING FILE '", "'"}))));
            v0 = null;
        } else {
            v0 = null;
        }
        ImportUtils.fromExcel(ImportUtils.inputStreamFromFilename(filename), columns, importProperties, importer);
    }

    /*
     * Unable to fully structure code
     */
    public static void fromExcel(InputStream is, List<String> columns, Map importProperties, Closure importer) {
        block25: {
            var4_4 = importProperties.get("sheetName");
            sheetName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, var4_4) != false ? var4_4 : "");
            var6_6 = (Integer)IndyInterface.bootstrap("invoke", "asType", 0, importProperties.get("startAt"), Integer.class);
            startAt = IndyInterface.bootstrap("cast", "()", 0, var6_6) != false ? var6_6 : Integer.valueOf(2);
            var8_8 = (Integer)IndyInterface.bootstrap("invoke", "asType", 0, importProperties.get("stopAt"), Integer.class);
            stopAt = IndyInterface.bootstrap("cast", "()", 0, var8_8) != false ? var8_8 : Integer.valueOf(0);
            var10_10 = (List)IndyInterface.bootstrap("invoke", "asType", 0, importProperties.get("booleanColumns"), List.class);
            booleanColumns = IndyInterface.bootstrap("cast", "()", 0, var10_10) != false ? var10_10 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            var12_12 = (List)IndyInterface.bootstrap("invoke", "asType", 0, importProperties.get("trueValues"), List.class);
            trueValues = IndyInterface.bootstrap("cast", "()", 0, var12_12) != false ? var12_12 : ScriptBytecodeAdapter.createList((Object[])new Object[]{"true"});
            var14_14 = (List)IndyInterface.bootstrap("invoke", "asType", 0, importProperties.get("falseValues"), List.class);
            falseValues = IndyInterface.bootstrap("cast", "()", 0, var14_14) != false ? var14_14 : ScriptBytecodeAdapter.createList((Object[])new Object[]{"false"});
            sw = new StopWatch();
            sw.start();
            wb = null;
            wb = WorkbookFactory.create((InputStream)is);
            sheet = null;
            v0 = sheetName;
            sheet = (v0 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v0)) != false ? wb.getSheet((String)sheetName) : wb.getSheetAt(0);
            line = 1;
            success = 0;
            error = 0;
            var22_22 = sheet;
            row = null;
            var24_24 = var22_22 != null ? var22_22.iterator() : null;
            if (var24_24 == null) break block25;
            while (var24_24.hasNext()) {
                block26: {
                    row = IndyInterface.bootstrap("cast", "()", 0, var24_24.next());
                    rowToImport = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                    cell = null;
                    var26_26 = row;
                    var28_28 = var26_26 != null ? var26_26.iterator() : null;
                    if (var28_28 == null) break block26;
                    while (var28_28.hasNext()) {
                        cell = IndyInterface.bootstrap("cast", "()", 0, var28_28.next());
                        if (!ScriptBytecodeAdapter.compareGreaterThanEqual((Object)line, (Object)startAt)) continue;
                        field = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt(columns, (int)cell.getColumnIndex()));
                        v1 = field;
                        if ((v1 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v1)) == false) continue;
                        value = null;
                        type = cell.getCellType();
                        var32_32 = type;
                        if (ScriptBytecodeAdapter.isCase((Object)var32_32, (Object)CellType.BOOLEAN)) {
                            value = cell.getBooleanCellValue();
                        } else if (ScriptBytecodeAdapter.isCase((Object)var32_32, (Object)CellType.NUMERIC)) {
                            value = cell.getNumericCellValue();
                        } else if (ScriptBytecodeAdapter.isCase((Object)var32_32, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{CellType.STRING, CellType.BLANK}))) {
                            value = cell.getStringCellValue();
                        } else {
                            if (ImportUtils.log.isErrorEnabled()) {
                                ImportUtils.log.error((String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{line, field}, new String[]{"CANNOT DETERMINE VALUE TYPE AT LINE ", " FROM FIELD '", "', RETURNING null"})));
                                v2 = null;
                            } else {
                                v2 = null;
                            }
                            value = null;
                        }
                        var33_33 = booleanColumns;
                        v3 = var33_33 == null ? field == null : DefaultGroovyMethods.isCase((Collection)var33_33, (Object)field);
                        if (!v3) ** GOTO lbl-1000
                        var34_34 = trueValues;
                        v4 = var34_34 == null ? value == null : DefaultGroovyMethods.isCase((Collection)var34_34, (Object)value);
                        if (v4) {
                            v5 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v5 = false;
                        }
                        if (v5) {
                            var35_35 = true;
                            ScriptBytecodeAdapter.invokeMethodN(ImportUtils.class, (Object)rowToImport, (String)"putAt", (Object[])new Object[]{field, var35_35});
                            continue;
                        }
                        var36_36 = booleanColumns;
                        v6 = var36_36 == null ? field == null : DefaultGroovyMethods.isCase((Collection)var36_36, (Object)field);
                        if (!v6) ** GOTO lbl-1000
                        var37_37 = falseValues;
                        v7 = var37_37 == null ? value == null : DefaultGroovyMethods.isCase((Collection)var37_37, (Object)value);
                        if (v7) {
                            v8 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v8 = false;
                        }
                        if (v8) {
                            var38_38 = false;
                            ScriptBytecodeAdapter.invokeMethodN(ImportUtils.class, (Object)rowToImport, (String)"putAt", (Object[])new Object[]{field, var38_38});
                            continue;
                        }
                        var39_39 = value;
                        ScriptBytecodeAdapter.invokeMethodN(ImportUtils.class, (Object)rowToImport, (String)"putAt", (Object[])new Object[]{field, var39_39});
                    }
                }
                if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)line, (Object)startAt)) {
                    if (ImportUtils.log.isTraceEnabled()) {
                        ImportUtils.log.trace((String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{rowToImport}, new String[]{"PROCESSING ROW: ", ""})));
                        v9 = null;
                    } else {
                        v9 = null;
                    }
                    try {
                        importer.call((Object)rowToImport);
                        success = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.next((Number)success));
                    }
                    catch (Exception e) {
                        ImportUtils.logError((Integer)line, (Map)rowToImport, importProperties, e);
                        error = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.next((Number)error));
                    }
                }
                line = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.next((Number)line));
                if (!(ScriptBytecodeAdapter.compareGreaterThan((Object)stopAt, (Object)0) != false && ScriptBytecodeAdapter.compareGreaterThan((Object)line, (Object)stopAt) != false)) continue;
                break;
            }
        }
        is.close();
        sw.stop();
        if (ImportUtils.log.isInfoEnabled()) {
            ImportUtils.log.info((String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{line, sw.toString(), success, error}, new String[]{"IMPORTED ", " ROWS IN ", " (SUCCESS: ", ", ERROR: ", ""})));
            v10 = null;
        } else {
            v10 = null;
        }
    }

    private static Object logError(Integer line, Map rowToImport, Map importProperties, Exception e) {
        GString errorMsg = new GStringImpl(new Object[]{line}, new String[]{"ERROR IMPORTING LINE: ", "\n"}).plus((GString)new GStringImpl(new Object[]{rowToImport}, new String[]{" - ROW: ", "\n"})).plus((GString)new GStringImpl(new Object[]{importProperties}, new String[]{" - Properties: ", "\n"}));
        Exception exception = e;
        if ((exception == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, exception)) != false) {
            errorMsg = errorMsg.plus((GString)new GStringImpl(new Object[]{LogUtils.logStackTrace((Exception)e)}, new String[]{" - Exception: ", "\n"}));
        }
        errorMsg = errorMsg.plus("\n");
        log.error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errorMsg)));
        return null;
    }

    private static FileInputStream inputStreamFromFilename(String filename) {
        File file = new File(filename);
        return new FileInputStream(file);
    }

    @Generated
    public static void fromCsv(String filename, List<String> columns, Closure importer) {
        ImportUtils.fromCsv(filename, columns, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), importer);
    }

    @Generated
    public static List<String> columnsFromCsv(String filename) {
        return ImportUtils.columnsFromCsv(filename, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    public static void fromCsv(String filename, Closure importer) {
        ImportUtils.fromCsv(filename, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), importer);
    }

    @Generated
    public static void fromCsv(InputStream is, List<String> columns, Closure importer) {
        ImportUtils.fromCsv(is, columns, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), importer);
    }

    @Generated
    public static void fromExcel(String filename, List<String> columns, Closure importer) {
        ImportUtils.fromExcel(filename, columns, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), importer);
    }

    @Generated
    public static void fromExcel(InputStream is, List<String> columns, Closure importer) {
        ImportUtils.fromExcel(is, columns, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), importer);
    }

    @Generated
    private static Object logError(Integer line, Map rowToImport, Map importProperties) {
        return ImportUtils.logError(line, rowToImport, importProperties, null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ImportUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"goowee.commons.importexport.ImportUtils");
    }
}

